/*
 * Decompiled with CFR 0.152.
 */
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;

class A2Frame
extends JFrame
implements ActionListener,
FocusListener {
    private JPanel cardPanel;
    private CardLayout cardLayout;
    private JPanel mainPanel;
    private JLabel title;
    private JSeparator separator1;
    private JRadioButton inputText;
    private JRadioButton readFile;
    private JLabel chainLabel;
    private JTextArea chainInput;
    private JScrollPane chainScroll;
    private JLabel chainFileLabel;
    private JTextField chainFile;
    private JButton chainFileBrowse;
    private JSeparator separator2;
    private JButton submit;
    private JPanel errorPanel;
    private JLabel errorTitle;
    private JLabel errorMessage;
    private JButton errorConfirm;
    private JPanel matrixPanel;
    private JTextArea matrixText;
    private JScrollPane matrixScroll;
    private JButton scrollToTop;
    private JLabel savedFileName;
    private JButton matrixPrint;
    private JButton matrixBack;
    private boolean readFromFile;

    public A2Frame() {
        this.initComponents();
    }

    private void initComponents() {
        this.cardLayout = new CardLayout();
        this.cardPanel = new JPanel(this.cardLayout);
        this.mainPanel = new JPanel();
        this.title = new JLabel();
        this.inputText = new JRadioButton();
        this.readFile = new JRadioButton();
        this.chainLabel = new JLabel();
        this.chainInput = new JTextArea();
        this.chainScroll = new JScrollPane(this.chainInput);
        this.chainFileLabel = new JLabel();
        this.chainFile = new JTextField();
        this.chainFileBrowse = new JButton();
        this.submit = new JButton();
        this.separator1 = new JSeparator();
        this.separator2 = new JSeparator();
        this.errorPanel = new JPanel();
        this.errorTitle = new JLabel();
        this.errorMessage = new JLabel();
        this.errorConfirm = new JButton();
        this.matrixPanel = new JPanel();
        this.matrixText = new JTextArea();
        this.matrixScroll = new JScrollPane(this.matrixText);
        this.scrollToTop = new JButton();
        this.savedFileName = new JLabel();
        this.matrixPrint = new JButton();
        this.matrixBack = new JButton();
        this.setTitle("Dot Matrix Plotter");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                A2Frame.this.exitForm();
            }
        });
        this.mainPanel.setLayout(null);
        this.mainPanel.setPreferredSize(new Dimension(460, 270));
        this.title.setFont(new Font("SansSerif", 1, 18));
        this.title.setText("Dot Matrix Plotter");
        this.mainPanel.add(this.title);
        this.title.setBounds(10, 10, 250, 20);
        this.mainPanel.add(this.separator1);
        this.separator1.setBounds(10, 40, 440, 10);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.inputText);
        buttonGroup.add(this.readFile);
        this.mainPanel.add(this.inputText);
        this.inputText.setBounds(10, 50, 20, 20);
        this.inputText.addActionListener(this);
        this.chainLabel.setText("Type/paste the chain:");
        this.mainPanel.add(this.chainLabel);
        this.chainLabel.setBounds(30, 50, 250, 20);
        this.mainPanel.add(this.chainScroll);
        this.chainScroll.setBounds(30, 80, 420, 110);
        this.chainInput.setFont(new Font("Dialog", 0, 10));
        this.chainInput.addFocusListener(this);
        this.chainInput.setLineWrap(true);
        this.mainPanel.add(this.readFile);
        this.readFile.setBounds(10, 200, 20, 20);
        this.readFile.addActionListener(this);
        this.chainFileLabel.setText("Select file:");
        this.mainPanel.add(this.chainFileLabel);
        this.chainFileLabel.setBounds(30, 200, 80, 20);
        this.mainPanel.add(this.chainFile);
        this.chainFile.setBounds(100, 200, 240, 20);
        this.chainFile.addFocusListener(this);
        this.chainFileBrowse.setText("Browse...");
        this.chainFileBrowse.addActionListener(this);
        this.mainPanel.add(this.chainFileBrowse);
        this.chainFileBrowse.setBounds(350, 200, 100, 20);
        this.mainPanel.add(this.separator2);
        this.separator2.setBounds(10, 230, 440, 10);
        this.submit.setText("Check");
        this.submit.addActionListener(this);
        this.mainPanel.add(this.submit);
        this.submit.setBounds(350, 240, 100, 20);
        this.errorPanel.setLayout(null);
        this.errorPanel.setPreferredSize(new Dimension(460, 270));
        this.errorPanel.setBackground(Color.white);
        this.errorPanel.add(this.errorTitle);
        this.errorTitle.setBounds(10, 20, 440, 20);
        this.errorTitle.setFont(new Font("SansSerif", 1, 16));
        this.errorTitle.setForeground(Color.red);
        this.errorTitle.setText("Error!");
        this.errorPanel.add(this.errorMessage);
        this.errorMessage.setBounds(10, 100, 440, 20);
        this.errorMessage.setHorizontalAlignment(0);
        this.errorConfirm.setText("OK");
        this.errorConfirm.addActionListener(this);
        this.errorPanel.add(this.errorConfirm);
        this.errorConfirm.setBounds(350, 240, 100, 20);
        this.matrixPanel.setLayout(null);
        this.matrixPanel.setPreferredSize(new Dimension(460, 270));
        this.matrixPanel.add(this.scrollToTop);
        this.scrollToTop.addActionListener(this);
        this.scrollToTop.setBounds(0, 0, 10, 10);
        this.matrixPanel.add(this.matrixScroll);
        this.matrixScroll.setBounds(10, 10, 440, 220);
        this.matrixText.setFont(new Font("monospaced", 1, 10));
        this.matrixText.setEditable(false);
        this.matrixPanel.add(this.savedFileName);
        this.savedFileName.setBounds(10, 240, 230, 20);
        this.matrixPanel.add(this.matrixPrint);
        this.matrixPrint.setText("Print");
        this.matrixPrint.addActionListener(this);
        this.matrixPrint.setBounds(250, 240, 100, 20);
        this.matrixPanel.add(this.matrixBack);
        this.matrixBack.setText("Back");
        this.matrixBack.addActionListener(this);
        this.matrixBack.setBounds(350, 240, 100, 20);
        this.cardPanel.add((Component)this.mainPanel, "main");
        this.cardPanel.add((Component)this.errorPanel, "error");
        this.cardPanel.add((Component)this.matrixPanel, "matrix");
        this.getContentPane().add(this.cardPanel);
        this.cardLayout.show(this.cardPanel, "main");
        this.pack();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block23: {
            Object object = actionEvent.getSource();
            if (object == this.inputText) {
                this.readFromFile = false;
            } else if (object == this.readFile) {
                this.readFromFile = true;
            } else if (object == this.chainFileBrowse) {
                this.readFile.setSelected(true);
                this.readFromFile = true;
                JFileChooser jFileChooser = new JFileChooser(new File("."));
                int n = jFileChooser.showOpenDialog(null);
                if (n == 0) {
                    File file = jFileChooser.getSelectedFile();
                    this.chainFile.setText(file.getPath());
                } else if (n != 1) {
                    System.out.println("ERROR: Could open the chosen file.");
                }
            } else if (object == this.submit) {
                MatrixMaker matrixMaker = new MatrixMaker();
                boolean bl = this.readFromFile ? matrixMaker.setChainFile(this.chainFile.getText()) : matrixMaker.setChain(this.chainInput.getText());
                if (bl) {
                    String string = matrixMaker.toString();
                    this.matrixText.setText(string);
                    String string2 = this.exportFile(string);
                    if (string2 == null) {
                        this.savedFileName.setText("No file was saved!");
                        this.savedFileName.setForeground(Color.red);
                    } else {
                        this.savedFileName.setText("File \"" + string2 + "\" saved.");
                    }
                    this.cardLayout.show(this.cardPanel, "matrix");
                } else {
                    this.errorMessage.setText("Invalid Input: Can only contain A,C,G & T.");
                    this.cardLayout.show(this.cardPanel, "error");
                }
            } else if (object == this.matrixPrint) {
                try {
                    PrintService printService = PrintServiceLookup.lookupDefaultPrintService();
                    if (printService == null) {
                        this.savedFileName.setText("Error! Printing not setup for Java.");
                        break block23;
                    }
                    this.savedFileName.setText("Printing...");
                    this.savedFileName.setForeground(Color.blue);
                    SimpleDoc simpleDoc = new SimpleDoc(this.matrixText.getText(), DocFlavor.STRING.TEXT_PLAIN, null);
                    DocPrintJob docPrintJob = printService.createPrintJob();
                    docPrintJob.print(simpleDoc, null);
                }
                catch (PrintException printException) {}
            } else if (object == this.errorConfirm || object == this.matrixBack) {
                this.cardLayout.show(this.cardPanel, "main");
            } else if (object == this.scrollToTop) {
                this.matrixScroll.getViewport().setViewPosition(new Point(0, 0));
            }
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.chainInput) {
            this.inputText.setSelected(true);
            this.readFromFile = false;
        } else if (focusEvent.getSource() == this.chainFile) {
            this.readFile.setSelected(true);
            this.readFromFile = true;
        }
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    private void exitForm() {
        System.exit(0);
    }

    public String exportFile(String string) {
        JFileChooser jFileChooser = new JFileChooser(new File("."));
        if (jFileChooser.showSaveDialog(null) == 0) {
            File file = jFileChooser.getSelectedFile();
            FileWriter fileWriter = null;
            try {
                fileWriter = new FileWriter(file);
            }
            catch (IOException iOException) {
                System.out.println("Could not export data to " + file.getPath());
                System.exit(1);
            }
            try {
                fileWriter.write(string);
            }
            catch (IOException iOException) {
                System.out.println("Error exporting data");
            }
            try {
                fileWriter.close();
            }
            catch (IOException iOException) {
                System.out.println("Error exporting data");
            }
            return file.getName();
        }
        System.out.println("ERROR: Could not save to chosen file.");
        return null;
    }
}

